IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Localidades_Reservadas') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Localidades_Reservadas
END
GO

CREATE FUNCTION [dbo].[CF_Localidades_Reservadas](@pId_Sector SMALLINT, @pFecha DATETIME, @pId_Lista_Precio_Evento SMALLINT)
RETURNS INT
AS
BEGIN
DECLARE @Cantidad_Localidades_Reservadas					INT
DECLARE @Hoy												DATE
DECLARE @Param_Loca_Cbte_Loca_Ent							VARCHAR(4)
DECLARE @Fecha_Reserva_Limite								DATE
DECLARE @Cant_Dias_Limite									INT
DECLARE @Flag_Ubic_Fija										TINYINT
DECLARE @Flag_Localidades									TINYINT
-------------------------------------------------------------------------------------------------------------------------------------

SET @Cantidad_Localidades_Reservadas = 0

-------------------------------------------------------------------------------------------------------------------------------------

SET @Hoy						= CONVERT(DATE, GETDATE())

SET @Param_Loca_Cbte_Loca_Ent	= SUBSTRING(LTRIM(RTRIM(dbo.CF_xParam('Loca_Cbte_Loca_Ent'))), 1, 4)

SELECT	
@Fecha_Reserva_Limite	= ISNULL(Evento_Fecha_Reserva_Limite, '19000101'),
@Cant_Dias_Limite		= ISNULL(Evento_Cant_Dias_Limite, 0),
@Flag_Localidades		= ISNULL(Flag_Localidades, 0)
FROM Prod_Listas_Precios 
WHERE 
Id_Lista_Precio = @pId_Lista_Precio_Evento

SELECT
@Flag_Ubic_Fija = Flag_Ubic_Fija
FROM Empresas_Sedes_Sectores
Where Id_Sector = @pId_Sector

--Si es un partido y no es localidad fija no debe buscar reserva 
IF (@Flag_Localidades = 2 AND @Flag_Ubic_Fija = 0)
BEGIN
	RETURN 0
END

IF(@Fecha_Reserva_Limite = '19000101')
BEGIN
	--Si Evento_Fecha_Reserva_Limite no esta grabado en el Evento (Prod_Listas_Precios) lo saca del parametro
	SET @Fecha_Reserva_Limite = CONVERT(DATE, dbo.CF_xParam('Loca_Fecha_Lim'))
END

IF(@Cant_Dias_Limite = 0)
BEGIN
	--Si Evento_Cant_Dias_Limite no esta grabado en el Evento (Prod_Listas_Precios) lo saca del parametro
	SET @Cant_Dias_Limite = CONVERT(INT, dbo.CF_xParam('Loca_Fecha_Lim_Dias'))
END

IF (@Fecha_Reserva_Limite < CONVERT(DATE, GETDATE()))
BEGIN
	SET @Cantidad_Localidades_Reservadas = 0
END
ELSE
BEGIN
	SET @Cantidad_Localidades_Reservadas = ISNULL(	(SELECT COUNT(*)
													FROM Cbtes_Items A, Cbtes B, Cbtes_Tipos C, Productos P
													WHERE
													A.Id_Trans = B.Id_Trans
													AND B.Id_Tipo_Cbte = C.Id_Tipo_Cbte
													AND A.Id_Producto = P.Id_Producto 
													AND A.Flag_QA = 'A' 
													AND B.Id_Estado_Cbte <> 3 
													AND B.Id_Estado_Cbte <> 0
													AND (C.Compromete_Factura = 1 OR C.Compromete_Remitos = 1 OR C.Compromete_Pedido = 1)
													AND A.Fecha_Venc < @Hoy
													AND DATEADD(DAY, @Cant_Dias_Limite, A.Fecha_Venc) >= @Hoy
													AND P.Tipo = 'L'
													AND B.Id_Tipo_Cbte <> @Param_Loca_Cbte_Loca_Ent
													AND P.Id_Sector = @pId_Sector
													AND NOT EXISTS(	SELECT 1 
																	FROM Cbtes_Items A2, Cbtes B2 ,Cbtes_Tipos C2
																	WHERE 
																	A2.Id_Trans = B2.Id_Trans
																	AND B2.Id_Tipo_Cbte = C2.Id_Tipo_Cbte
																	AND A2.Id_Producto = A.Id_Producto
																	AND A2.Flag_QA = 'A' 
																	AND B2.Id_Estado_Cbte <> 3 
																	AND B2.Id_Estado_Cbte <> 0
																	AND (C2.Compromete_Factura = 1 OR C2.Compromete_Remitos = 1 OR C2.Compromete_Pedido = 1)
																	AND A2.Fecha_QA < DATEADD(DAY, 1, CONVERT(DATE, @pFecha))
																	AND A2.Fecha_Venc >= CONVERT(DATE, @pFecha))
													)
													, 0)
END

-------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@Cantidad_Localidades_Reservadas, 0)
END
